*========================================================================================
* Basisklasse fr Windows API Objekte
*========================================================================================
Define Class CHandled as Custom

	nHandle = -1
	cName = ""

*========================================================================================
* Beim Lschen des Objektes Handle schlieen
*========================================================================================
Procedure Destroy
	This.CloseHandle()
EndProc

*========================================================================================
* Das Objekt schlieen
*========================================================================================
Procedure CloseHandle
	If This.IsValidHandle()
		If This.DoCloseHandle(This.nHandle)
			This.nHandle = -1
		EndIf
	EndIf 	
EndProc
Procedure DoCloseHandle( tnHandle )
	Declare Long CloseHandle in Win32API Long
Return CloseHandle(This.nHandle) # 0

*========================================================================================
* Ist der Handle gltig?
*========================================================================================
Procedure IsValidHandle
Return not InList(This.nHandle,-1,0,0xFFFFFFFF)

*========================================================================================
* Wartet die angegebene Zeit, dass das Objekt signalisiert wird.
*========================================================================================
Procedure WaitForSingleObject
LParameter tnTimeOut
	Local lnResult, llOK
	If This.IsValidHandle()
		Declare Long WaitForSingleObject in Win32API Long, Long
		lnResult = WaitForSingleObject(This.nHandle,m.tnTimeOut)
		llOK = (m.lnResult == 0)
	Else
		llOK = .F.
	EndIf
Return m.llOK

*========================================================================================
* Liefert den Namen des Objektes zurck
*========================================================================================
Procedure GetName
Return This.cName

*========================================================================================
* Schlafen gehen
*========================================================================================
Procedure Sleep
LParameter tnMilliSeconds
	Declare Sleep in Win32API Long
	Sleep(m.tnMilliSeconds)
EndProc

EndDefine 


*========================================================================================
* Event Objekt
*========================================================================================
Define Class CEvent as CHandled

	lManualReset = .T.

*========================================================================================
* Erzeugt ein Event
*========================================================================================
Procedure Create
LParameter tlInitialState
	Declare LONG CreateEvent in Win32API String, Long, Long, String
	This.nHandle = CreateEvent( ;
		NULL, ;
		Iif(This.lManualReset,1,0), ;
		Iif(m.tlInitialState,1,0), ;
		This.GetName() ;
	)
Return This.IsValidHandle()

*========================================================================================
* Setzt das Event. Das Objekt gilt damit als signalisiert und eventuelle unterbrochene
* Threads werden fortgefhrt.
*========================================================================================
Procedure Set
	If This.IsValidHandle()
		Declare SetEvent in Win32API Long
		SetEvent( This.nHandle )
	EndIf 
EndProc

*========================================================================================
* Lscht das Signal
*========================================================================================
Procedure Clear
	If This.IsValidHandle()
		Declare ResetEvent in Win32API Long
		ResetEvent( This.nHandle )
	EndIf 
EndProc

EndDefine 


*========================================================================================
* MUTEX Objekt
*========================================================================================
Define Class CMutex as CHandled

*========================================================================================
* Erzeugt einen MUTEX
*========================================================================================
Procedure Create
	Declare LONG CreateMutex in Win32API Long, Long, String
	This.nHandle = CreateMutex(0,0,This.GetName())
Return This.IsValidHandle()

*========================================================================================
* Gibt einen MUTEX frei, nachdem er mit Wait angefordert wurde.
*========================================================================================
Procedure Free
	Declare LONG ReleaseMutex in Win32API LONG
	ReleaseMutex( This.nHandle )
EndProc

EndDefine


*========================================================================================
* Zugriff auf den Heap Speicher. Zum Lesen und Schreiben wird SYS(2600) verwendet.
*========================================================================================
Define Class CHeapMemory as Custom
	
	Add Object colAllocated as Collection

*========================================================================================
* Allokiert die gewnschte Menge Speicher und liefert die Adresse zurck. Es wird 0 zu-
* rckgegeben, wenn der Speicher nicht allokiert werden konnte.
*========================================================================================
Function Alloc
LParameter tnBytesToAllocate
	Local lnProcessHeap, lnAddress
	Declare Long GetProcessHeap in Win32API
	Declare Long HeapAlloc in Win32API Long, Long, Long
	lnProcessHeap = GetProcessHeap()
	If m.lnProcessHeap == 0
		lnAddress = 0
	Else
		lnAddress = HeapAlloc( m.lnProcessHeap, 0, m.tnBytesToAllocate )
	EndIf 
	If m.lnAddress # 0
		This.colAllocated.Add( Str(m.lnAddress) )
	EndIf
Return m.lnAddress

*========================================================================================
* Gibt allokierten Speicher wieder frei
*========================================================================================
Procedure Free
LParameter tnAddress
	Local lnProcessHeap
	Declare Long GetProcessHeap in Win32API
	Declare Long HeapFree in Win32API Long, Long, Long
	lnProcessHeap = GetProcessHeap()
	If m.lnProcessHeap # 0
		HeapFree( m.lnProcessHeap, 0, m.tnAddress )
	EndIf 
	This.colAllocated.Remove( Str(m.tnAddress) )
EndProc

*========================================================================================
* Beim Freigeben des Objektes auch den allokierten Speicher freigeben
*========================================================================================
Procedure Destroy
	Local lnBlock
	For lnBlock = This.colAllocated.Count to 1 step -1
		This.Free( Val(This.colAllocated(m.lnBlock)) )
	EndFor
EndProc

EndDefine


*========================================================================================
* FileMapping (Shared Memory)
*========================================================================================
Define Class CFileMap as CHandled

	nMemory = 0
	nSize = 0
	lNew = .F.

*========================================================================================
* Erzeugt das FileMapping
*
*! 29.01.2003  #534  ChrisL
*========================================================================================
Procedure Create
	Declare Long CreateFileMapping in Win32API Long, String, Long, Long, Long, String
	Declare Long MapViewOfFile in Win32API Long, Long, Long, Long, Long
	Declare Long GetLastError in Win32API
	This.nHandle = CreateFileMapping( -1, NULL, 4, 0, This.nSize, This.GetName() )
	If This.nHandle > 0
		This.lNew = GetLastError() == 0
		This.nMemory = MapViewOfFile( This.nHandle, 6, 0, 0, This.nSize )
		If This.nMemory == 0
			This.CloseHandle()
		EndIf 
	EndIf 
Return This.IsValidHandle()

*========================================================================================
* Beim Schlieen des Handle muss zustzlich das File Mapping Objekt freigegeben werden.
*========================================================================================
Procedure DoCloseHandle( tnHandle )
	Declare UnmapViewOfFile in Win32API Long
	UnmapViewOfFile( This.nMemory)
	This.nMemory = 0
	DoDefault(m.tnHandle)
EndProc

EndDefine 


*========================================================================================
* Named Pipe
*========================================================================================
Define Class CNamedPipeServer as CHandled

	nMaxInstances = 255
	nMaxMessageSize = 64*024
	nTimeOutDefault = 5*1000
	lIsConnected = .F.

*========================================================================================
* Mit dem Erstellen der Named Pipe steht der Server zur Verfgung
*========================================================================================
Procedure Create
	Declare Long CreateNamedPipe in Win32API ;
		STRING lpName, ;
		LONG dwOpenMode, ;
		LONG dwPipeMode, ;
		LONG nMaxInstances, ;
		LONG nOutBufferSize, ;
		LONG nInBufferSize, ;
		Long nDefaultTimeOut, ;
		STRING lpSecurityAttributes
	This.nHandle = CreateNamedPipe( ;
		This.GetName(), ;
		0x00000003, ; && PIPE_ACCESS_DUPLEX
		0x00000004 + 0x00000000, ; && PIPE_TYPE_MESSAGE + PIPE_WAIT
		This.nMaxInstances, ;
		This.nMaxMessageSize, ;
		This.nMaxMessageSize, ;
		This.nTimeOutDefault, ;
		NULL ;
	)
Return This.IsValidHandle()

*========================================================================================
* Wartet unendlich lange auf einen Client
*========================================================================================
Procedure WaitForClientConnect
	Declare Long ConnectNamedPipe in WIn32API Long hNamedPipe, Long lpOverlapped
	If This.lIsConnected
		This.Disconnect()
	EndIf
	This.lIsConnected = ConnectNamedPipe( This.nHandle, 0 ) == 0
Return This.lIsConnected

*========================================================================================
* Unterbricht die Verbindung zum Client serverseitig. Der Client erhlt fortan beim Zu-
* griff auf die Pipe nur noch Fehlermeldungen.
*========================================================================================
Procedure Disconnect
Lparameters tlFlush
	Declare Long DisconnectNamedPipe in Win32API Long hNamedPipe
	Declare FlushFileBuffers in Win32API Long hNamedPipe
	If m.tlFlush
		FlushFileBuffers( This.nHandle )
	EndIf 
	DisconnectNamedPipe( This.nHandle )
	This.lIsConnected = .F.
EndProc

*========================================================================================
* Pipes mu ein Pipe-Kennzeichen vorangestellt werden.
*========================================================================================
Function GetName
Return "\\.\pipe\" + This.cName

*========================================================================================
* Eine Nachricht aus der Pipe lesen
*========================================================================================
Procedure Read
	Local lnMsgSize, lnResult, lnAvailable, lcMsg
	Declare LONG ReadFile in win32api Long, String@, Long, Long@, Long
	Declare Long PeekNamedPipe in Win32API Long, Long, Long, Long, Long@, Long@
	lnMsgSize = 0
	lnAvailable = 0
	lnResult = PeekNamedPipe(This.nHandle,0,0,0,@lnAvailable,@lnMsgSize)
	If m.lnResult == 0 or m.lnMsgSize == 0
		lcMsg = ""
	Else
		lcMsg = Space(m.lnMsgSize*2)
		lnResult = ReadFile(This.nHandle,@lcMsg,m.lnMsgSize,@lnAvailable,0)
		If m.lnResult == 0
			lcMsg = ""
		Else
			lcMsg = Left(m.lcMsg,m.lnAvailable)
		EndIf 
	EndIf
Return m.lcMsg


EndDefine


*========================================================================================
* 
*========================================================================================
Define Class CNamedPipeClient as CHandled 
	
*=======================================================================================
* ffnet eine Pipe von der Client Seite
*========================================================================================
Procedure Open
	Declare Long CreateFile in Win32API ;
	  String lpFileName, ;
		Long dwDesiredAccess, ;
		Long dwShareMode, ;
		String lpSecurityAttributes, ;
		Long dwCreationDisposition, ;
		Long dwFlagsAndAttributes, ;
		Long hTemplateFile
	This.nHandle = CreateFile( ;
		This.GetName(), ;
		0x80000000 + 0x40000000, ; && GENERIC_READ + GENERIC_WRITE,
		0x00000001 + 0x00000002, ; && FILE_SHARE_READ + FILE_SHARE_WRITE,
		NULL, ;
		3, ; && OPEN_EXISTING,
		0x00000080, ; && FILE_ATTRIBUTE_NORMAL,
		0 ;
	)
Return This.IsValidHandle()

*========================================================================================
* Schreibt eine Message 
*========================================================================================
Procedure Write
LParameter tcMessage
	Declare LONG WriteFile in win32api Long, String, Long, Long@, Long
	WriteFile(This.nHandle,m.tcMessage,Len(m.tcMessage),0,0)
EndProc

*========================================================================================
* Pipes mu ein Pipe-Kennzeichen vorangestellt werden.
*========================================================================================
Function GetName
Return "\\.\pipe\" + This.cName

*========================================================================================
* Eine Nachricht aus der Pipe lesen
*========================================================================================
Procedure Read
	Local lnMsgSize, lnResult, lnAvailable, lcMsg
	Declare LONG ReadFile in win32api Long, String@, Long, Long, Long
	Declare Long PeekNamedPipe in Win32API Long, Long, Long, Long, Long@, Long@
	lnMsgSize = 0
	lnAvailable = 0
	lnResult = PeekNamedPipe(This.nHandle,0,0,0,@lnAvailable,@lnMsgSize)
	If m.lnResult == 0 or m.lnMsgSize == 0
		lcMsg = ""
	Else
		lcMsg = Space(m.lnMsgSize)
		lnResult = ReadFile(This.nHandle,@lcMsg,m.lnMsgSize,0,0)
		If m.lnResult == 0
			lcMsg = ""
		EndIf 
	EndIf
Return m.lcMsg

EndDefine 