*====================================================================
* SetVSSUser.PRG
*
* Let's you specify the login information that is used by VFP for all
* further projects you open which are placed under version control.
* VFP always tries to log you into the default database using your
* Windows login information. The problems with that approach are that
* you get a login dialog if you use a different name, which is not
* only disturbing, but also a problem for automation. OTOH, when you
* use the defaults, you can't easily switch the database.
*
* This program affects only the current VFP session and only projects
* you open after calling this program. You can call it as many times
* as needed.
*
* You can call it from a project hook object, but you must do so in
* the Init of the project hook. Afterwards the project is already
* connected to the VSS database.
*
* SECURITY: The password is not encrypted. In a corporate environ-
*           ment you need to get the permission of your administra-
*           tors to save the VSS password in a readable format.
*
*--------------------------------------------------------------------
* SYNTAX
*
* SetVSSUser( [tcUser], [tcPassword] )
*
* Pass the login information. If you want to clear the settings and
* restore the defaults, you can omit a parameter or pass NULL.
*
*--------------------------------------------------------------------
* HOW IT WORKS
*
* It's not a very well documented fact, but VSS can use environment
* variables to determine login information if nothing else is speci-
* fied. These variables are SSUSER and SSPWD. An API function can be 
* used to change environment settings for the current process only.
*
* Although there is a SSDIR variable that lets you specify the VSS
* database, this variable is not respected by the SCCAPI interface.
* Only SSExplorer and the command line tools respect this setting.
* the SCCAPI always uses the "Current Database" setting in the regis-
* try. It does NOT use the "API Current Database" setting.
* 
*====================================================================
LParameter tcUser, tcPassword

	*-----------------------------------------------------------------
	* Get the login information. By using NULL, we effectively remove
	* the environment variables.
	*-----------------------------------------------------------------
	Local lcUser, lcPassword
	If Type("m.tcUser")=="C" and Type("m.tcPassword")=="C"
		lcUser = m.tcUser
		lcPassword = m.tcPassword
	Else
		lcUser = Alltrim(NULL)
		lcPassword = Alltrim(NULL)
	Endif
	
	*-----------------------------------------------------------------
	* Set the environment variables SSUSER and SSPWD
	*-----------------------------------------------------------------
	Local llOK
	llOK = .T.
	Declare Long SetEnvironmentVariable in Win32API String, String
	If SetEnvironmentVariable( "SSUSER", m.lcUser ) == 0
		llOK = .F.
	Endif
	If SetEnvironmentVariable( "SSPWD", m.lcPassword ) == 0
		llOK = .F.
	Endif
	
Return m.llOK
