*========================================================================================
* Updates a project file with updated information from a PJM file.
*
* (...) Currently, only files are added or removed. Project settings are not updated.
*========================================================================================
LParameter tcFile

	*--------------------------------------------------------------------------------------
	* If no file has been passed, prompt user for file.
	*--------------------------------------------------------------------------------------
	Local lcFile
	If Vartype(m.tcFile) == "C"
		lcFile = m.tcFile
	Else
		lcFile = GetFile("pjm")
		If Empty(m.lcFile)
			Return
		EndIf
	EndIf
	If not File(m.lcFile)
		MessageBox("File doesn't exist")
		Return
	EndIf
	
	*--------------------------------------------------------------------------------------
	* Remove all files from the project that have been placed under source control.
	*--------------------------------------------------------------------------------------
	Use (ForceExt(m.lcFile,"pjx")) Again Shared Alias __PJX
	If not Used("__PJX")
		Return
	EndIf
	Delete All for Recno() > 1 and not local

	*--------------------------------------------------------------------------------------
	* Add all files
	*--------------------------------------------------------------------------------------
	Local laFiles[1], lnCurFile, lnCnt, lcType, lcName
	lnCnt = ALines(laFiles,StrExtract(FileToStr(m.lcFile),"[ProjectFiles]","[EOF]"))
	For lnCurFile=1 to m.lnCnt
		If not Empty(laFiles[m.lnCurFile])
			lcType = StrExtract(laFiles[m.lnCurFile],",",",",1)
			lcName = StrExtract(laFiles[m.lnCurFile],",",",",2)+Chr(0)
			Append blank
			Replace next 1 ;
				Name with m.lcName, ;
				type with m.lcType, ;
				Id with Val(StrExtract(laFiles[m.lnCurFile],"",",")), ;
				Exclude with StrExtract(laFiles[m.lnCurFile],",",",",3)==".T.", ;
				mainprog with StrExtract(laFiles[m.lnCurFile],",",",",4)==".T.", ;
				cpid with Val(StrExtract(laFiles[m.lnCurFile],",",",",5)), ;
				comments with StrExtract(laFiles[m.lnCurFile],",","",8), ;
				Key with Upper(JustStem(StrExtract(laFiles[m.lnCurFile],",",",",2))), ;
				sccdata with Replicate(Chr(0),268), ;
				local with .F.
			If m.lcType == "W"
				Replace Reserved1 with JustStem(m.lcName)+Chr(0)
			EndIf
			Wait WINDOW NOWAIT Name
		EndIf
	EndFor

	*--------------------------------------------------------------------------------------
	* close project
	*--------------------------------------------------------------------------------------
	Use
