	*-----------------------------------------------------------------
	* Device Parameters for GetDeviceCaps()
	*-----------------------------------------------------------------
	#DEFINE DRIVERVERSION 0     && Device driver version
	#DEFINE TECHNOLOGY    2     && Device classification
	#DEFINE HORZSIZE      4     && Horizontal size in millimeters
	#DEFINE VERTSIZE      6     && Vertical size in millimeters
	#DEFINE HORZRES       8     && Horizontal width in pixels
	#DEFINE VERTRES       10    && Vertical height in pixels
	#DEFINE BITSPIXEL     12    && Number of bits per pixel
	#DEFINE PLANES        14    && Number of planes
	#DEFINE NUMBRUSHES    16    && Number of brushes the device has
	#DEFINE NUMPENS       18    && Number of pens the device has
	#DEFINE NUMMARKERS    20    && Number of markers the device has
	#DEFINE NUMFONTS      22    && Number of fonts the device has
	#DEFINE NUMCOLORS     24    && Number of colors the device supports
	#DEFINE PDEVICESIZE   26    && Size required for device descriptor
	#DEFINE CURVECAPS     28    && Curve capabilities
	#DEFINE LINECAPS      30    && Line capabilities
	#DEFINE POLYGONALCAPS 32    && Polygonal capabilities
	#DEFINE TEXTCAPS      34    && Text capabilities
	#DEFINE CLIPCAPS      36    && Clipping capabilities
	#DEFINE RASTERCAPS    38    && Bitblt capabilities
	#DEFINE ASPECTX       40    && Length of the X leg
	#DEFINE ASPECTY       42    && Length of the Y leg
	#DEFINE ASPECTXY      44    && Length of the hypotenuse
	#DEFINE SHADEBLENDCAPS 45   && Shading and blending caps
	#DEFINE LOGPIXELSX    88    && Logical pixels/inch in X
	#DEFINE LOGPIXELSY    90    && Logical pixels/inch in Y
	#DEFINE SIZEPALETTE  104    && Number of entries in physical palette
	#DEFINE NUMRESERVED  106    && Number of reserved entries in palette
	#DEFINE COLORRES     108    && Actual color resolution
	#DEFINE PHYSICALWIDTH   110 && Physical Width in device units           */
	#DEFINE PHYSICALHEIGHT  111 && Physical Height in device units          */
	#DEFINE PHYSICALOFFSETX 112 && Physical Printable Area x margin         */
	#DEFINE PHYSICALOFFSETY 113 && Physical Printable Area y margin         */
	#DEFINE SCALINGFACTORX  114 && Scaling factor x                         */
	#DEFINE SCALINGFACTORY  115 && Scaling factor y                         */
	#DEFINE VREFRESH        116 && Current vertical refresh rate of the    */
	                            && display device (for displays only) in Hz*/
	#DEFINE DESKTOPVERTRES  117 && Horizontal width of entire desktop in   */
	                            && pixels                                  */
	#DEFINE DESKTOPHORZRES  118 && Vertical height of entire desktop in    */
	                            && pixels                                  */
	#DEFINE BLTALIGNMENT    119 && Preferred blt alignment                 */

	*-----------------------------------------------------------------
	* Background Modes
	*-----------------------------------------------------------------
	#DEFINE TRANSPARENT         1
	#DEFINE OPAQUE              2
	
	*-----------------------------------------------------------------
	* Constants for EnumDisplaySettings()
	*-----------------------------------------------------------------
	#DEFINE ENUM_CURRENT_SETTINGS       -1
	#DEFINE ENUM_REGISTRY_SETTINGS      -2

	*-----------------------------------------------------------------
	* DEVMODE structure: field selection bits (dmFields)
	*-----------------------------------------------------------------
	#DEFINE DM_ORIENTATION      0x00000001
	#DEFINE DM_PAPERSIZE        0x00000002
	#DEFINE DM_PAPERLENGTH      0x00000004
	#DEFINE DM_PAPERWIDTH       0x00000008
	#DEFINE DM_SCALE            0x00000010
	#DEFINE DM_POSITION         0x00000020
	#DEFINE DM_COPIES           0x00000100
	#DEFINE DM_DEFAULTSOURCE    0x00000200
	#DEFINE DM_PRINTQUALITY     0x00000400
	#DEFINE DM_COLOR            0x00000800
	#DEFINE DM_DUPLEX           0x00001000
	#DEFINE DM_YRESOLUTION      0x00002000
	#DEFINE DM_TTOPTION         0x00004000
	#DEFINE DM_COLLATE          0x00008000
	#DEFINE DM_FORMNAME         0x00010000
	#DEFINE DM_LOGPIXELS        0x00020000
	#DEFINE DM_BITSPERPEL       0x00040000
	#DEFINE DM_PELSWIDTH        0x00080000
	#DEFINE DM_PELSHEIGHT       0x00100000
	#DEFINE DM_DISPLAYFLAGS     0x00200000
	#DEFINE DM_DISPLAYFREQUENCY 0x00400000
	#DEFINE DM_ICMMETHOD        0x00800000
	#DEFINE DM_ICMINTENT        0x01000000
	#DEFINE DM_MEDIATYPE        0x02000000
	#DEFINE DM_DITHERTYPE       0x04000000
	#DEFINE DM_PANNINGWIDTH     0x08000000
	#DEFINE DM_PANNINGHEIGHT    0x10000000

	*-----------------------------------------------------------------
	* dwInfoLevel parameter for WNetGetUniversalName()
	*-----------------------------------------------------------------
	#DEFINE UNIVERSAL_NAME_INFO_LEVEL   	0x00000001
	#DEFINE REMOTE_NAME_INFO_LEVEL      	0x00000002

	*-----------------------------------------------------------------
	* Error values returned by WNetGetUniversalName()
	*-----------------------------------------------------------------
	#DEFINE ERROR_BAD_DEVICE                1200
	#DEFINE ERROR_CONNECTION_UNAVAIL        1201
	#DEFINE ERROR_EXTENDED_ERROR            1208
	#DEFINE ERROR_MORE_DATA                  234
	#DEFINE ERROR_NOT_SUPPORTED               50
	#DEFINE ERROR_NO_NET_OR_BAD_PATH        1203
	#DEFINE ERROR_NO_NETWORK                2138
	#DEFINE ERROR_NOT_CONNECTED             2250
	#DEFINE ERROR_INVALID_ADDRESS            487
	